import bpy
from bpy.types import Operator
from ....addon.naming import FluidLabNaming
from ....libs.functions.get_common_vars import get_common_vars


class FLUIDLAB_OT_world_rm(Operator):
    bl_idname = "vdblab.world_rm"
    bl_label = "Remove World"
    bl_description = "Remove VDBLab World"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        
        scn, fluidlab = get_common_vars(context, get_scn=True, get_fluidlab=True)

        worlds = bpy.data.worlds
        target_lib = FluidLabNaming.WORLD

        if FluidLabNaming.WORLD in worlds:
            worlds.remove(worlds[target_lib], do_unlink=True, do_id_user=True, do_ui_user=True)
            scn.world = fluidlab.last_world
            fluidlab.last_world = None

        return {'FINISHED'}
